; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -mattr=+aix-small-local-exec-tls < %s \
; RUN:      | FileCheck %s --check-prefix=SMALL-LOCAL-EXEC-SMALLCM64
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff --code-model=large \
; RUN:      -mattr=+aix-small-local-exec-tls < %s | FileCheck %s \
; RUN:      --check-prefix=SMALL-LOCAL-EXEC-LARGECM64

@ThreadLocalVarInit = thread_local(localexec) global i64 1, align 8
@VarInit = local_unnamed_addr global i64 87, align 8
@IThreadLocalVarInit = internal thread_local(localexec) global i64 1, align 8
declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull) #1
%struct.anon = type { i64 }
@ThreadLocalStruct = thread_local(localexec) global %struct.anon zeroinitializer, align 1
@d = thread_local(localexec) global [87 x i64] zeroinitializer, align 8

define nonnull ptr @AddrTest1() local_unnamed_addr #0 {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: AddrTest1:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r3, d[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: AddrTest1:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, d[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @d)
  ret ptr %0
}

define i64 @testUnaligned() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: testUnaligned:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r3, ThreadLocalStruct[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r3, 0(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: testUnaligned:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, ThreadLocalStruct[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r3, 0(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = call align 1 ptr @llvm.threadlocal.address.p0(ptr align 1 @ThreadLocalStruct)
  %x = getelementptr inbounds %struct.anon, ptr %0, i32 0, i32 0
  %1 = load i64, ptr %x, align 1
  ret i64 %1
}

define void @storeITLInit(i64 noundef %x) {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: storeITLInit:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: storeITLInit:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @IThreadLocalVarInit)
  store i64 %x, ptr %0, align 8
  ret void
}

define void @storeTLInit(i64 noundef %x) {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: storeTLInit:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r3, ThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: storeTLInit:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r3, ThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @ThreadLocalVarInit)
  store i64 %x, ptr %0, align 8
  ret void
}

define i64 @loadITLInit() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: loadITLInit:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: loadITLInit:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @IThreadLocalVarInit)
  %1 = load i64, ptr %0, align 8
  ret i64 %1
}

define i64 @loadITLInit2() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: loadITLInit2:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r4, L..C0(r2) # @VarInit
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r4, 0(r4)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    add r3, r4, r3
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: loadITLInit2:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    addis r4, L..C0@u(r2)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r4, L..C0@l(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r4, 0(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    add r3, r4, r3
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @IThreadLocalVarInit)
  %1 = load i64, ptr %0, align 8
  %2 = load i64, ptr @VarInit, align 8
  %add = add nsw i64 %2, %1
  ret i64 %add
}

define i64 @loadTLInit() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: loadTLInit:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r3, ThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: loadTLInit:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r3, ThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @ThreadLocalVarInit)
  %1 = load i64, ptr %0, align 8
  ret i64 %1
}

define i64 @loadTLInit2() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: loadTLInit2:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r4, L..C0(r2) # @VarInit
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r3, ThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r4, 0(r4)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    add r3, r4, r3
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: loadTLInit2:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    addis r4, L..C0@u(r2)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r3, ThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r4, L..C0@l(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r4, 0(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    add r3, r4, r3
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @ThreadLocalVarInit)
  %1 = load i64, ptr %0, align 8
  %2 = load i64, ptr @VarInit, align 8
  %add = add nsw i64 %2, %1
  ret i64 %add
}

define void @loadStore1(i64 noundef %x) {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: loadStore1:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    addi r3, r3, 9
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: loadStore1:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    addi r3, r3, 9
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r3, IThreadLocalVarInit[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @IThreadLocalVarInit)
  %1 = load i64, ptr %0, align 8
  %add = add nsw i64 %1, 9
  store i64 %add, ptr %0, align 8
  ret void
}
