/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.basicsearch.ANDExpression;
import com.sourceforge.knecs.dsm.basicsearch.BasicSearchQuery;
import com.sourceforge.knecs.dsm.basicsearch.FromClause;
import com.sourceforge.knecs.dsm.basicsearch.LTExpression;
import com.sourceforge.knecs.dsm.basicsearch.PropContainsExpression;
import com.sourceforge.knecs.dsm.basicsearch.QueryScope;
import com.sourceforge.knecs.dsm.basicsearch.SelectClause;
import com.sourceforge.knecs.dsm.basicsearch.WhereClause;
import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIPool;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.NSProperty;
import java.util.Hashtable;
import org.apache.webdav.lib.PropertyName;

public class TestDaslBasicsearch {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: TestDaslBasicsearch <url>");
            System.exit(-1);
        }
        DSIPool pool = DSIPool.getDSIPool();
        String url2 = args[0];
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url2, dal);
        try {
            BasicSearchQuery bsQuery = new BasicSearchQuery();
            PropertyName dispProp = new PropertyName(BasicSearchQuery.DAV_NS.getURI(), "displayname");
            PropertyName mimeProp = new PropertyName(BasicSearchQuery.DAV_NS.getURI(), "getcontenttype");
            PropertyName lengthProp = new PropertyName(BasicSearchQuery.DAV_NS.getURI(), "getcontentlength");
            SelectClause selectClause = new SelectClause();
            selectClause.addSelectProperty(dispProp);
            bsQuery.setSelectClause(selectClause);
            FromClause fromClause = new FromClause();
            QueryScope scope = new QueryScope(url2, "INFINITE");
            fromClause.addScope(scope);
            bsQuery.setFromClause(fromClause);
            WhereClause whereClause = new WhereClause();
            PropContainsExpression propContains = new PropContainsExpression(dispProp, "3-21G");
            LTExpression ltExpression = new LTExpression(lengthProp, "100000");
            ANDExpression andExpression = new ANDExpression(propContains, ltExpression);
            whereClause.addExpression(andExpression);
            bsQuery.setWhereClause(whereClause);
            String query = bsQuery.getQuery();
            System.out.println("Executing query: " + query);
            Hashtable properties = dsi.doDaslQuery(query, Integer.MAX_VALUE);
            if (properties != null) {
                System.out.println("Num matches: " + properties.size());
                for (String url2 : properties.keySet()) {
                    System.out.println("\nurl " + url2);
                    Hashtable propcoll = (Hashtable)properties.get(url2);
                    System.out.println("property size" + propcoll.size());
                    for (NSProperty ns : propcoll.keySet()) {
                        DSIProperty prop = (DSIProperty)propcoll.get(ns);
                        String propVal = prop.getPropertyAsString().trim();
                        if (propVal.length() == 0) {
                            propVal = prop.getPropertyAsXMLString(true).trim();
                        }
                        System.out.println(prop.getPropertyKey() + "=" + propVal);
                    }
                }
            } else {
                System.out.println("result set is null.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.getMessage());
        }
        System.exit(0);
    }
}

