# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AccessRule(_serialization.Model):
    """Access rule in a network security perimeter configuration profile.

    :ivar name: Name of the access rule.
    :vartype name: str
    :ivar properties: Properties of Access Rule.
    :vartype properties: ~azure.mgmt.search.models.AccessRuleProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "AccessRuleProperties"},
    }

    def __init__(
        self, *, name: Optional[str] = None, properties: Optional["_models.AccessRuleProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the access rule.
        :paramtype name: str
        :keyword properties: Properties of Access Rule.
        :paramtype properties: ~azure.mgmt.search.models.AccessRuleProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class AccessRuleProperties(_serialization.Model):
    """Properties of Access Rule.

    :ivar direction: Direction of Access Rule. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.search.models.AccessRuleDirection
    :ivar address_prefixes: Address prefixes in the CIDR format for inbound rules.
    :vartype address_prefixes: list[str]
    :ivar subscriptions: Subscriptions for inbound rules.
    :vartype subscriptions: list[~azure.mgmt.search.models.AccessRulePropertiesSubscriptionsItem]
    :ivar network_security_perimeters: Network security perimeters for inbound rules.
    :vartype network_security_perimeters: list[~azure.mgmt.search.models.NetworkSecurityPerimeter]
    :ivar fully_qualified_domain_names: Fully qualified domain names (FQDN) for outbound rules.
    :vartype fully_qualified_domain_names: list[str]
    :ivar email_addresses: Email addresses for outbound rules.
    :vartype email_addresses: list[str]
    :ivar phone_numbers: Phone numbers for outbound rules.
    :vartype phone_numbers: list[str]
    """

    _attribute_map = {
        "direction": {"key": "direction", "type": "str"},
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
        "subscriptions": {"key": "subscriptions", "type": "[AccessRulePropertiesSubscriptionsItem]"},
        "network_security_perimeters": {"key": "networkSecurityPerimeters", "type": "[NetworkSecurityPerimeter]"},
        "fully_qualified_domain_names": {"key": "fullyQualifiedDomainNames", "type": "[str]"},
        "email_addresses": {"key": "emailAddresses", "type": "[str]"},
        "phone_numbers": {"key": "phoneNumbers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        direction: Optional[Union[str, "_models.AccessRuleDirection"]] = None,
        address_prefixes: Optional[List[str]] = None,
        subscriptions: Optional[List["_models.AccessRulePropertiesSubscriptionsItem"]] = None,
        network_security_perimeters: Optional[List["_models.NetworkSecurityPerimeter"]] = None,
        fully_qualified_domain_names: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        phone_numbers: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword direction: Direction of Access Rule. Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.search.models.AccessRuleDirection
        :keyword address_prefixes: Address prefixes in the CIDR format for inbound rules.
        :paramtype address_prefixes: list[str]
        :keyword subscriptions: Subscriptions for inbound rules.
        :paramtype subscriptions: list[~azure.mgmt.search.models.AccessRulePropertiesSubscriptionsItem]
        :keyword network_security_perimeters: Network security perimeters for inbound rules.
        :paramtype network_security_perimeters:
         list[~azure.mgmt.search.models.NetworkSecurityPerimeter]
        :keyword fully_qualified_domain_names: Fully qualified domain names (FQDN) for outbound rules.
        :paramtype fully_qualified_domain_names: list[str]
        :keyword email_addresses: Email addresses for outbound rules.
        :paramtype email_addresses: list[str]
        :keyword phone_numbers: Phone numbers for outbound rules.
        :paramtype phone_numbers: list[str]
        """
        super().__init__(**kwargs)
        self.direction = direction
        self.address_prefixes = address_prefixes
        self.subscriptions = subscriptions
        self.network_security_perimeters = network_security_perimeters
        self.fully_qualified_domain_names = fully_qualified_domain_names
        self.email_addresses = email_addresses
        self.phone_numbers = phone_numbers


class AccessRulePropertiesSubscriptionsItem(_serialization.Model):
    """Subscription identifiers.

    :ivar id: The fully qualified Azure resource ID of the subscription e.g.
     ('/subscriptions/00000000-0000-0000-0000-000000000000').
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The fully qualified Azure resource ID of the subscription e.g.
         ('/subscriptions/00000000-0000-0000-0000-000000000000').
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AdminKeyResult(_serialization.Model):
    """Response containing the primary and secondary admin API keys for a given Azure AI Search
    service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_key: The primary admin API key of the search service.
    :vartype primary_key: str
    :ivar secondary_key: The secondary admin API key of the search service.
    :vartype secondary_key: str
    """

    _validation = {
        "primary_key": {"readonly": True},
        "secondary_key": {"readonly": True},
    }

    _attribute_map = {
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_key: Optional[str] = None
        self.secondary_key: Optional[str] = None


class AsyncOperationResult(_serialization.Model):
    """The details of a long running asynchronous shared private link resource operation.

    :ivar status: The current status of the long running asynchronous shared private link resource
     operation. Known values are: "Running", "Succeeded", and "Failed".
    :vartype status: str or ~azure.mgmt.search.models.SharedPrivateLinkResourceAsyncOperationResult
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.SharedPrivateLinkResourceAsyncOperationResult"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The current status of the long running asynchronous shared private link
         resource operation. Known values are: "Running", "Succeeded", and "Failed".
        :paramtype status: str or
         ~azure.mgmt.search.models.SharedPrivateLinkResourceAsyncOperationResult
        """
        super().__init__(**kwargs)
        self.status = status


class CheckNameAvailabilityInput(_serialization.Model):
    """Input of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The search service name to validate. Search service names must only contain
     lowercase letters, digits or dashes, cannot use dash as the first two or last one characters,
     cannot contain consecutive dashes, and must be between 2 and 60 characters in length. Required.
    :vartype name: str
    :ivar type: The type of the resource whose name is to be validated. This value must always be
     'searchServices'. Required. Default value is "searchServices".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "searchServices"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The search service name to validate. Search service names must only contain
         lowercase letters, digits or dashes, cannot use dash as the first two or last one characters,
         cannot contain consecutive dashes, and must be between 2 and 60 characters in length. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityOutput(_serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_name_available: A value indicating whether the name is available.
    :vartype is_name_available: bool
    :ivar reason: The reason why the name is not available. 'Invalid' indicates the name provided
     does not match the naming requirements (incorrect length, unsupported characters, etc.).
     'AlreadyExists' indicates that the name is already in use and is therefore unavailable. Known
     values are: "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.search.models.UnavailableNameReason
    :ivar message: A message that explains why the name is invalid and provides resource naming
     requirements. Available only if 'Invalid' is returned in the 'reason' property.
    :vartype message: str
    """

    _validation = {
        "is_name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "is_name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.is_name_available: Optional[bool] = None
        self.reason: Optional[Union[str, "_models.UnavailableNameReason"]] = None
        self.message: Optional[str] = None


class CloudErrorBody(_serialization.Model):
    """Describes a particular API error with an error code and a message.

    :ivar code: An error code that describes the error condition more precisely than an HTTP status
     code. Can be used to programmatically handle specific error cases.
    :vartype code: str
    :ivar message: A message that describes the error in detail and provides debugging information.
    :vartype message: str
    :ivar target: The target of the particular error (for example, the name of the property in
     error).
    :vartype target: str
    :ivar details: Contains nested errors that are related to this error.
    :vartype details: list[~azure.mgmt.search.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An error code that describes the error condition more precisely than an HTTP
         status code. Can be used to programmatically handle specific error cases.
        :paramtype code: str
        :keyword message: A message that describes the error in detail and provides debugging
         information.
        :paramtype message: str
        :keyword target: The target of the particular error (for example, the name of the property in
         error).
        :paramtype target: str
        :keyword details: Contains nested errors that are related to this error.
        :paramtype details: list[~azure.mgmt.search.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class DataPlaneAadOrApiKeyAuthOption(_serialization.Model):
    """Indicates that either the API key or an access token from a Microsoft Entra ID tenant can be
    used for authentication.

    :ivar aad_auth_failure_mode: Describes what response the data plane API of a search service
     would send for requests that failed authentication. Known values are: "http403" and
     "http401WithBearerChallenge".
    :vartype aad_auth_failure_mode: str or ~azure.mgmt.search.models.AadAuthFailureMode
    """

    _attribute_map = {
        "aad_auth_failure_mode": {"key": "aadAuthFailureMode", "type": "str"},
    }

    def __init__(
        self, *, aad_auth_failure_mode: Optional[Union[str, "_models.AadAuthFailureMode"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword aad_auth_failure_mode: Describes what response the data plane API of a search service
         would send for requests that failed authentication. Known values are: "http403" and
         "http401WithBearerChallenge".
        :paramtype aad_auth_failure_mode: str or ~azure.mgmt.search.models.AadAuthFailureMode
        """
        super().__init__(**kwargs)
        self.aad_auth_failure_mode = aad_auth_failure_mode


class DataPlaneAuthOptions(_serialization.Model):
    """Defines the options for how the search service authenticates a data plane request. This cannot
    be set if 'disableLocalAuth' is set to true.

    :ivar api_key_only: Indicates that only the API key can be used for authentication.
    :vartype api_key_only: JSON
    :ivar aad_or_api_key: Indicates that either the API key or an access token from a Microsoft
     Entra ID tenant can be used for authentication.
    :vartype aad_or_api_key: ~azure.mgmt.search.models.DataPlaneAadOrApiKeyAuthOption
    """

    _attribute_map = {
        "api_key_only": {"key": "apiKeyOnly", "type": "object"},
        "aad_or_api_key": {"key": "aadOrApiKey", "type": "DataPlaneAadOrApiKeyAuthOption"},
    }

    def __init__(
        self,
        *,
        api_key_only: Optional[JSON] = None,
        aad_or_api_key: Optional["_models.DataPlaneAadOrApiKeyAuthOption"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword api_key_only: Indicates that only the API key can be used for authentication.
        :paramtype api_key_only: JSON
        :keyword aad_or_api_key: Indicates that either the API key or an access token from a Microsoft
         Entra ID tenant can be used for authentication.
        :paramtype aad_or_api_key: ~azure.mgmt.search.models.DataPlaneAadOrApiKeyAuthOption
        """
        super().__init__(**kwargs)
        self.api_key_only = api_key_only
        self.aad_or_api_key = aad_or_api_key


class EncryptionWithCmk(_serialization.Model):
    """Describes a policy that determines how resources within the search service are to be encrypted
    with customer managed keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enforcement: Describes how a search service should enforce compliance if it finds objects
     that aren't encrypted with the customer-managed key. Known values are: "Disabled", "Enabled",
     and "Unspecified".
    :vartype enforcement: str or ~azure.mgmt.search.models.SearchEncryptionWithCmk
    :ivar encryption_compliance_status: Returns the status of search service compliance with
     respect to non-CMK-encrypted objects. If a service has more than one unencrypted object, and
     enforcement is enabled, the service is marked as noncompliant. Known values are: "Compliant"
     and "NonCompliant".
    :vartype encryption_compliance_status: str or
     ~azure.mgmt.search.models.SearchEncryptionComplianceStatus
    """

    _validation = {
        "encryption_compliance_status": {"readonly": True},
    }

    _attribute_map = {
        "enforcement": {"key": "enforcement", "type": "str"},
        "encryption_compliance_status": {"key": "encryptionComplianceStatus", "type": "str"},
    }

    def __init__(
        self, *, enforcement: Optional[Union[str, "_models.SearchEncryptionWithCmk"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword enforcement: Describes how a search service should enforce compliance if it finds
         objects that aren't encrypted with the customer-managed key. Known values are: "Disabled",
         "Enabled", and "Unspecified".
        :paramtype enforcement: str or ~azure.mgmt.search.models.SearchEncryptionWithCmk
        """
        super().__init__(**kwargs)
        self.enforcement = enforcement
        self.encryption_compliance_status: Optional[Union[str, "_models.SearchEncryptionComplianceStatus"]] = None


class Identity(_serialization.Model):
    """Details about the search service identity. A null value indicates that the search service has
    no identity assigned.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The principal ID of the system-assigned identity of the search service.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system-assigned identity of the search service.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned'
     includes both an identity created by the system and a set of user assigned identities. The type
     'None' will remove all identities from the service. Required. Known values are: "None",
     "SystemAssigned", "UserAssigned", and "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.search.models.IdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource IDs in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.search.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.IdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the resource. The type 'SystemAssigned,
         UserAssigned' includes both an identity created by the system and a set of user assigned
         identities. The type 'None' will remove all identities from the service. Required. Known values
         are: "None", "SystemAssigned", "UserAssigned", and "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.search.models.IdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource IDs in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.search.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class IpRule(_serialization.Model):
    """The IP restriction rule of the Azure AI Search service.

    :ivar value: Value corresponding to a single IPv4 address (eg., 123.1.2.3) or an IP range in
     CIDR format (eg., 123.1.2.3/24) to be allowed.
    :vartype value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Value corresponding to a single IPv4 address (eg., 123.1.2.3) or an IP range in
         CIDR format (eg., 123.1.2.3/24) to be allowed.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class ListQueryKeysResult(_serialization.Model):
    """Response containing the query API keys for a given Azure AI Search service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The query keys for the Azure AI Search service.
    :vartype value: list[~azure.mgmt.search.models.QueryKey]
    :ivar next_link: Request URL that can be used to query next page of query keys. Returned when
     the total number of requested query keys exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[QueryKey]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.QueryKey"]] = None
        self.next_link: Optional[str] = None


class NetworkRuleSet(_serialization.Model):
    """Network specific rules that determine how the Azure AI Search service may be reached.

    :ivar ip_rules: A list of IP restriction rules that defines the inbound network(s) with
     allowing access to the search service endpoint. At the meantime, all other public IP networks
     are blocked by the firewall. These restriction rules are applied only when the
     'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public
     interface is not allowed even with any public IP rules, and private endpoint connections would
     be the exclusive access method.
    :vartype ip_rules: list[~azure.mgmt.search.models.IpRule]
    :ivar bypass: Possible origins of inbound traffic that can bypass the rules defined in the
     'ipRules' section. Known values are: "None" and "AzureServices".
    :vartype bypass: str or ~azure.mgmt.search.models.SearchBypass
    """

    _attribute_map = {
        "ip_rules": {"key": "ipRules", "type": "[IpRule]"},
        "bypass": {"key": "bypass", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_rules: Optional[List["_models.IpRule"]] = None,
        bypass: Optional[Union[str, "_models.SearchBypass"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_rules: A list of IP restriction rules that defines the inbound network(s) with
         allowing access to the search service endpoint. At the meantime, all other public IP networks
         are blocked by the firewall. These restriction rules are applied only when the
         'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public
         interface is not allowed even with any public IP rules, and private endpoint connections would
         be the exclusive access method.
        :paramtype ip_rules: list[~azure.mgmt.search.models.IpRule]
        :keyword bypass: Possible origins of inbound traffic that can bypass the rules defined in the
         'ipRules' section. Known values are: "None" and "AzureServices".
        :paramtype bypass: str or ~azure.mgmt.search.models.SearchBypass
        """
        super().__init__(**kwargs)
        self.ip_rules = ip_rules
        self.bypass = bypass


class NetworkSecurityPerimeter(_serialization.Model):
    """Information about a network security perimeter (NSP).

    :ivar id: Fully qualified Azure resource ID of the NSP resource.
    :vartype id: str
    :ivar perimeter_guid: Universal unique ID (UUID) of the network security perimeter.
    :vartype perimeter_guid: str
    :ivar location: Location of the network security perimeter.
    :vartype location: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "perimeter_guid": {"key": "perimeterGuid", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        perimeter_guid: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified Azure resource ID of the NSP resource.
        :paramtype id: str
        :keyword perimeter_guid: Universal unique ID (UUID) of the network security perimeter.
        :paramtype perimeter_guid: str
        :keyword location: Location of the network security perimeter.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.perimeter_guid = perimeter_guid
        self.location = location


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    """


class NetworkSecurityPerimeterConfiguration(ProxyResource):
    """Network security perimeter (NSP) configuration resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    :ivar properties: Network security configuration properties.
    :vartype properties: ~azure.mgmt.search.models.NetworkSecurityPerimeterConfigurationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "NetworkSecurityPerimeterConfigurationProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.NetworkSecurityPerimeterConfigurationProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Network security configuration properties.
        :paramtype properties:
         ~azure.mgmt.search.models.NetworkSecurityPerimeterConfigurationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class NetworkSecurityPerimeterConfigurationListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Result of a list NSP (network security perimeter) configurations request.

    :ivar value: Array of network security perimeter results.
    :vartype value: list[~azure.mgmt.search.models.NetworkSecurityPerimeterConfiguration]
    :ivar next_link: The link used to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkSecurityPerimeterConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkSecurityPerimeterConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Array of network security perimeter results.
        :paramtype value: list[~azure.mgmt.search.models.NetworkSecurityPerimeterConfiguration]
        :keyword next_link: The link used to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkSecurityPerimeterConfigurationProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Network security configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of a network security perimeter configuration that
     is being created or updated. Known values are: "Succeeded", "Creating", "Updating", "Deleting",
     "Accepted", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.search.models.NetworkSecurityPerimeterConfigurationProvisioningState
    :ivar provisioning_issues: List of provisioning issues, if any.
    :vartype provisioning_issues: list[~azure.mgmt.search.models.ProvisioningIssue]
    :ivar network_security_perimeter: Information about a network security perimeter (NSP).
    :vartype network_security_perimeter: ~azure.mgmt.search.models.NetworkSecurityPerimeter
    :ivar resource_association: Information about resource association.
    :vartype resource_association: ~azure.mgmt.search.models.ResourceAssociation
    :ivar profile: Network security perimeter configuration profile.
    :vartype profile: ~azure.mgmt.search.models.NetworkSecurityProfile
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "provisioning_issues": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "provisioning_issues": {"key": "provisioningIssues", "type": "[ProvisioningIssue]"},
        "network_security_perimeter": {"key": "networkSecurityPerimeter", "type": "NetworkSecurityPerimeter"},
        "resource_association": {"key": "resourceAssociation", "type": "ResourceAssociation"},
        "profile": {"key": "profile", "type": "NetworkSecurityProfile"},
    }

    def __init__(
        self,
        *,
        network_security_perimeter: Optional["_models.NetworkSecurityPerimeter"] = None,
        resource_association: Optional["_models.ResourceAssociation"] = None,
        profile: Optional["_models.NetworkSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_security_perimeter: Information about a network security perimeter (NSP).
        :paramtype network_security_perimeter: ~azure.mgmt.search.models.NetworkSecurityPerimeter
        :keyword resource_association: Information about resource association.
        :paramtype resource_association: ~azure.mgmt.search.models.ResourceAssociation
        :keyword profile: Network security perimeter configuration profile.
        :paramtype profile: ~azure.mgmt.search.models.NetworkSecurityProfile
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[
            Union[str, "_models.NetworkSecurityPerimeterConfigurationProvisioningState"]
        ] = None
        self.provisioning_issues: Optional[List["_models.ProvisioningIssue"]] = None
        self.network_security_perimeter = network_security_perimeter
        self.resource_association = resource_association
        self.profile = profile


class NetworkSecurityProfile(_serialization.Model):
    """Network security perimeter configuration profile.

    :ivar name: Name of the profile.
    :vartype name: str
    :ivar access_rules_version: Current access rules version.
    :vartype access_rules_version: int
    :ivar access_rules: List of Access Rules.
    :vartype access_rules: list[~azure.mgmt.search.models.AccessRule]
    :ivar diagnostic_settings_version: Current diagnostic settings version.
    :vartype diagnostic_settings_version: int
    :ivar enabled_log_categories: List of log categories that are enabled.
    :vartype enabled_log_categories: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_rules_version": {"key": "accessRulesVersion", "type": "int"},
        "access_rules": {"key": "accessRules", "type": "[AccessRule]"},
        "diagnostic_settings_version": {"key": "diagnosticSettingsVersion", "type": "int"},
        "enabled_log_categories": {"key": "enabledLogCategories", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        access_rules_version: Optional[int] = None,
        access_rules: Optional[List["_models.AccessRule"]] = None,
        diagnostic_settings_version: Optional[int] = None,
        enabled_log_categories: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the profile.
        :paramtype name: str
        :keyword access_rules_version: Current access rules version.
        :paramtype access_rules_version: int
        :keyword access_rules: List of Access Rules.
        :paramtype access_rules: list[~azure.mgmt.search.models.AccessRule]
        :keyword diagnostic_settings_version: Current diagnostic settings version.
        :paramtype diagnostic_settings_version: int
        :keyword enabled_log_categories: List of log categories that are enabled.
        :paramtype enabled_log_categories: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_rules_version = access_rules_version
        self.access_rules = access_rules
        self.diagnostic_settings_version = diagnostic_settings_version
        self.enabled_log_categories = enabled_log_categories


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.search.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.search.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.search.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.search.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """The result of the request to list REST API operations. It contains a list of operations and a
    URL to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of operations by Azure AI Search, some supported by the resource provider
     and others by data plane APIs.
    :vartype value: list[~azure.mgmt.search.models.Operation]
    :ivar next_link: The URL to get the next set of operation list results, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class PrivateEndpointConnection(Resource):
    """Describes an existing private endpoint connection to the Azure AI Search service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    :ivar properties: Describes the properties of an existing private endpoint connection to the
     Azure AI Search service.
    :vartype properties: ~azure.mgmt.search.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.PrivateEndpointConnectionProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Describes the properties of an existing private endpoint connection to the
         Azure AI Search service.
        :paramtype properties: ~azure.mgmt.search.models.PrivateEndpointConnectionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateEndpointConnectionListResult(_serialization.Model):
    """Response containing a list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of private endpoint connections.
    :vartype value: list[~azure.mgmt.search.models.PrivateEndpointConnection]
    :ivar next_link: Request URL that can be used to query next page of private endpoint
     connections. Returned when the total number of requested private endpoint connections exceed
     maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.PrivateEndpointConnection"]] = None
        self.next_link: Optional[str] = None


class PrivateEndpointConnectionProperties(_serialization.Model):
    """Describes the properties of an existing private endpoint connection to the search service.

    :ivar private_endpoint: The private endpoint resource from Microsoft.Network provider.
    :vartype private_endpoint:
     ~azure.mgmt.search.models.PrivateEndpointConnectionPropertiesPrivateEndpoint
    :ivar private_link_service_connection_state: Describes the current state of an existing Azure
     Private Link service connection to the private endpoint.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.search.models.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionState
    :ivar group_id: The group ID of the Azure resource for which the private link service is for.
    :vartype group_id: str
    :ivar provisioning_state: The provisioning state of the private link service connection. Valid
     values are Updating, Deleting, Failed, Succeeded, Incomplete, or Canceled. Known values are:
     "Updating", "Deleting", "Failed", "Succeeded", "Incomplete", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.search.models.PrivateLinkServiceConnectionProvisioningState
    """

    _attribute_map = {
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpointConnectionPropertiesPrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionState",
        },
        "group_id": {"key": "groupId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointConnectionPropertiesPrivateEndpoint"] = None,
        private_link_service_connection_state: Optional[
            "_models.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionState"
        ] = None,
        group_id: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.PrivateLinkServiceConnectionProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint resource from Microsoft.Network provider.
        :paramtype private_endpoint:
         ~azure.mgmt.search.models.PrivateEndpointConnectionPropertiesPrivateEndpoint
        :keyword private_link_service_connection_state: Describes the current state of an existing
         Azure Private Link service connection to the private endpoint.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.search.models.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionState
        :keyword group_id: The group ID of the Azure resource for which the private link service is
         for.
        :paramtype group_id: str
        :keyword provisioning_state: The provisioning state of the private link service connection.
         Valid values are Updating, Deleting, Failed, Succeeded, Incomplete, or Canceled. Known values
         are: "Updating", "Deleting", "Failed", "Succeeded", "Incomplete", and "Canceled".
        :paramtype provisioning_state: str or
         ~azure.mgmt.search.models.PrivateLinkServiceConnectionProvisioningState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.group_id = group_id
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionPropertiesPrivateEndpoint(_serialization.Model):  # pylint: disable=name-too-long
    """The private endpoint resource from Microsoft.Network provider.

    :ivar id: The resource ID of the private endpoint resource from Microsoft.Network provider.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource ID of the private endpoint resource from Microsoft.Network provider.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionState(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Describes the current state of an existing Azure Private Link service connection to the private
    endpoint.

    :ivar status: Status of the the private link service connection. Valid values are Pending,
     Approved, Rejected, or Disconnected. Known values are: "Pending", "Approved", "Rejected", and
     "Disconnected".
    :vartype status: str or ~azure.mgmt.search.models.PrivateLinkServiceConnectionStatus
    :ivar description: The description for the private link service connection state.
    :vartype description: str
    :ivar actions_required: A description of any extra actions that may be required.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateLinkServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: str = "None",
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the the private link service connection. Valid values are Pending,
         Approved, Rejected, or Disconnected. Known values are: "Pending", "Approved", "Rejected", and
         "Disconnected".
        :paramtype status: str or ~azure.mgmt.search.models.PrivateLinkServiceConnectionStatus
        :keyword description: The description for the private link service connection state.
        :paramtype description: str
        :keyword actions_required: A description of any extra actions that may be required.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PrivateLinkResource(Resource):
    """Describes a supported private link resource for the Azure AI Search service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    :ivar properties: Describes the properties of a supported private link resource for the Azure
     AI Search service.
    :vartype properties: ~azure.mgmt.search.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties: Optional["_models.PrivateLinkResourceProperties"] = None


class PrivateLinkResourceProperties(_serialization.Model):
    """Describes the properties of a supported private link resource for the Azure AI Search service.
    For a given API version, this represents the 'supported' groupIds when creating a shared
    private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The group ID of the private link resource.
    :vartype group_id: str
    :ivar required_members: The list of required members of the private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: The list of required DNS zone names of the private link resource.
    :vartype required_zone_names: list[str]
    :ivar shareable_private_link_resource_types: The list of resources that are onboarded to
     private link service, that are supported by Azure AI Search.
    :vartype shareable_private_link_resource_types:
     list[~azure.mgmt.search.models.ShareablePrivateLinkResourceType]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "required_zone_names": {"readonly": True},
        "shareable_private_link_resource_types": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
        "shareable_private_link_resource_types": {
            "key": "shareablePrivateLinkResourceTypes",
            "type": "[ShareablePrivateLinkResourceType]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.group_id: Optional[str] = None
        self.required_members: Optional[List[str]] = None
        self.required_zone_names: Optional[List[str]] = None
        self.shareable_private_link_resource_types: Optional[List["_models.ShareablePrivateLinkResourceType"]] = None


class PrivateLinkResourcesResult(_serialization.Model):
    """Response containing a list of supported Private Link Resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of supported Private Link Resources.
    :vartype value: list[~azure.mgmt.search.models.PrivateLinkResource]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.PrivateLinkResource"]] = None


class ProvisioningIssue(_serialization.Model):
    """Describes a provisioning issue for a network security perimeter configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the issue.
    :vartype name: str
    :ivar properties: Details of a provisioning issue for a network security perimeter (NSP)
     configuration. Resource providers should generate separate provisioning issue elements for each
     separate issue detected, and include a meaningful and distinctive description, as well as any
     appropriate suggestedResourceIds and suggestedAccessRules.
    :vartype properties: ~azure.mgmt.search.models.ProvisioningIssueProperties
    """

    _validation = {
        "name": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "ProvisioningIssueProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.properties: Optional["_models.ProvisioningIssueProperties"] = None


class ProvisioningIssueProperties(_serialization.Model):
    """Details of a provisioning issue for a network security perimeter (NSP) configuration. Resource
    providers should generate separate provisioning issue elements for each separate issue
    detected, and include a meaningful and distinctive description, as well as any appropriate
    suggestedResourceIds and suggestedAccessRules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar issue_type: Type of issue. Known values are: "Unknown",
     "ConfigurationPropagationFailure", "MissingPerimeterConfiguration", and
     "MissingIdentityConfiguration".
    :vartype issue_type: str or ~azure.mgmt.search.models.IssueType
    :ivar severity: Severity of the issue. Known values are: "Warning" and "Error".
    :vartype severity: str or ~azure.mgmt.search.models.Severity
    :ivar description: Description of the issue.
    :vartype description: str
    :ivar suggested_resource_ids: Fully qualified resource IDs of suggested resources that can be
     associated to the network security perimeter (NSP) to remediate the issue.
    :vartype suggested_resource_ids: list[str]
    :ivar suggested_access_rules: Access rules that can be added to the network security profile
     (NSP) to remediate the issue.
    :vartype suggested_access_rules: list[~azure.mgmt.search.models.AccessRule]
    """

    _validation = {
        "issue_type": {"readonly": True},
        "severity": {"readonly": True},
        "description": {"readonly": True},
        "suggested_resource_ids": {"readonly": True},
        "suggested_access_rules": {"readonly": True},
    }

    _attribute_map = {
        "issue_type": {"key": "issueType", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "suggested_resource_ids": {"key": "suggestedResourceIds", "type": "[str]"},
        "suggested_access_rules": {"key": "suggestedAccessRules", "type": "[AccessRule]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.issue_type: Optional[Union[str, "_models.IssueType"]] = None
        self.severity: Optional[Union[str, "_models.Severity"]] = None
        self.description: Optional[str] = None
        self.suggested_resource_ids: Optional[List[str]] = None
        self.suggested_access_rules: Optional[List["_models.AccessRule"]] = None


class QueryKey(_serialization.Model):
    """Describes an API key for a given Azure AI Search service that conveys read-only permissions on
    the docs collection of an index.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the query API key. Query names are optional, but assigning a name can
     help you remember how it's used.
    :vartype name: str
    :ivar key: The value of the query API key.
    :vartype key: str
    """

    _validation = {
        "name": {"readonly": True},
        "key": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.key: Optional[str] = None


class QuotaUsageResult(_serialization.Model):
    """Describes the quota usage for a particular SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID of the quota usage SKU endpoint for Microsoft.Search provider.
    :vartype id: str
    :ivar unit: The unit of measurement for the search SKU.
    :vartype unit: str
    :ivar current_value: The currently used up value for the particular search SKU.
    :vartype current_value: int
    :ivar limit: The quota limit for the particular search SKU.
    :vartype limit: int
    :ivar name: The name of the SKU supported by Azure AI Search.
    :vartype name: ~azure.mgmt.search.models.QuotaUsageResultName
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "QuotaUsageResultName"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        unit: Optional[str] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The resource ID of the quota usage SKU endpoint for Microsoft.Search provider.
        :paramtype id: str
        :keyword unit: The unit of measurement for the search SKU.
        :paramtype unit: str
        :keyword current_value: The currently used up value for the particular search SKU.
        :paramtype current_value: int
        :keyword limit: The quota limit for the particular search SKU.
        :paramtype limit: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name: Optional["_models.QuotaUsageResultName"] = None


class QuotaUsageResultName(_serialization.Model):
    """The name of the SKU supported by Azure AI Search.

    :ivar value: The SKU name supported by Azure AI Search.
    :vartype value: str
    :ivar localized_value: The localized string value for the SKU name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The SKU name supported by Azure AI Search.
        :paramtype value: str
        :keyword localized_value: The localized string value for the SKU name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class QuotaUsagesListResult(_serialization.Model):
    """Response containing the quota usage information for all the supported SKUs of Azure AI Search.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The quota usages for the SKUs supported by Azure AI Search.
    :vartype value: list[~azure.mgmt.search.models.QuotaUsageResult]
    :ivar next_link: Request URL that can be used to query next page of quota usages. Returned when
     the total number of requested quota usages exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[QuotaUsageResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.QuotaUsageResult"]] = None
        self.next_link: Optional[str] = None


class ResourceAssociation(_serialization.Model):
    """Information about resource association.

    :ivar name: Name of the resource association.
    :vartype name: str
    :ivar access_mode: Access mode of the resource association. Known values are: "Enforced",
     "Learning", and "Audit".
    :vartype access_mode: str or ~azure.mgmt.search.models.ResourceAssociationAccessMode
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_mode": {"key": "accessMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        access_mode: Optional[Union[str, "_models.ResourceAssociationAccessMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource association.
        :paramtype name: str
        :keyword access_mode: Access mode of the resource association. Known values are: "Enforced",
         "Learning", and "Audit".
        :paramtype access_mode: str or ~azure.mgmt.search.models.ResourceAssociationAccessMode
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_mode = access_mode


class SearchManagementRequestOptions(_serialization.Model):
    """Parameter group.

    :ivar client_request_id: A client-generated GUID value that identifies this request. If
     specified, this will be included in response information as a way to track the request.
    :vartype client_request_id: str
    """

    _attribute_map = {
        "client_request_id": {"key": "clientRequestId", "type": "str"},
    }

    def __init__(self, *, client_request_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_request_id: A client-generated GUID value that identifies this request. If
         specified, this will be included in response information as a way to track the request.
        :paramtype client_request_id: str
        """
        super().__init__(**kwargs)
        self.client_request_id = client_request_id


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class SearchService(TrackedResource):
    """Describes an Azure AI Search service and its current state.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: The SKU of the search service, which determines price tier and capacity limits. This
     property is required when creating a new search service.
    :vartype sku: ~azure.mgmt.search.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.search.models.Identity
    :ivar replica_count: The number of replicas in the search service. If specified, it must be a
     value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic SKU.
    :vartype replica_count: int
    :ivar partition_count: The number of partitions in the search service; if specified, it can be
     1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For 'standard3'
     services with hostingMode set to 'highDensity', the allowed values are between 1 and 3.
    :vartype partition_count: int
    :ivar endpoint: The endpoint of the Azure AI Search service.
    :vartype endpoint: str
    :ivar hosting_mode: Applicable only for the standard3 SKU. You can set this property to enable
     up to 3 high density partitions that allow up to 1000 indexes, which is much higher than the
     maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either 'default'
     or 'highDensity'. For all other SKUs, this value must be 'default'. Known values are: "default"
     and "highDensity".
    :vartype hosting_mode: str or ~azure.mgmt.search.models.HostingMode
    :ivar compute_type: Configure this property to support the search service using either the
     Default Compute or Azure Confidential Compute. Known values are: "default" and "confidential".
    :vartype compute_type: str or ~azure.mgmt.search.models.ComputeType
    :ivar public_network_access: This value can be set to 'enabled' to avoid breaking changes on
     existing customer resources and templates. If set to 'disabled', traffic over public interface
     is not allowed, and private endpoint connections would be the exclusive access method. Known
     values are: "enabled", "disabled", and "securedByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.search.models.PublicNetworkAccess
    :ivar status: The status of the search service. Possible values include: 'running': The search
     service is running and no provisioning operations are underway. 'provisioning': The search
     service is being provisioned or scaled up or down. 'deleting': The search service is being
     deleted. 'degraded': The search service is degraded. This can occur when the underlying search
     units are not healthy. The search service is most likely operational, but performance might be
     slow and some requests might be dropped. 'disabled': The search service is disabled. In this
     state, the service will reject all API requests. 'error': The search service is in an error
     state. 'stopped': The search service is in a subscription that's disabled. If your service is
     in the degraded, disabled, or error states, it means the Azure AI Search team is actively
     investigating the underlying issue. Dedicated services in these states are still chargeable
     based on the number of search units provisioned. Known values are: "running", "provisioning",
     "deleting", "degraded", "disabled", "error", and "stopped".
    :vartype status: str or ~azure.mgmt.search.models.SearchServiceStatus
    :ivar status_details: The details of the search service status.
    :vartype status_details: str
    :ivar provisioning_state: The state of the last provisioning operation performed on the search
     service. Provisioning is an intermediate state that occurs while service capacity is being
     established. After capacity is set up, provisioningState changes to either 'Succeeded' or
     'Failed'. Client applications can poll provisioning status (the recommended polling interval is
     from 30 seconds to one minute) by using the Get Search Service operation to see when an
     operation is completed. If you are using the free service, this value tends to come back as
     'Succeeded' directly in the call to Create search service. This is because the free service
     uses capacity that is already set up. Known values are: "succeeded", "provisioning", and
     "failed".
    :vartype provisioning_state: str or ~azure.mgmt.search.models.ProvisioningState
    :ivar network_rule_set: Network specific rules that determine how the Azure AI Search service
     may be reached.
    :vartype network_rule_set: ~azure.mgmt.search.models.NetworkRuleSet
    :ivar data_exfiltration_protections: A list of data exfiltration scenarios that are explicitly
     disallowed for the search service. Currently, the only supported value is 'All' to disable all
     possible data export scenarios with more fine grained controls planned for the future.
    :vartype data_exfiltration_protections: list[str or
     ~azure.mgmt.search.models.SearchDataExfiltrationProtection]
    :ivar encryption_with_cmk: Specifies any policy regarding encryption of resources (such as
     indexes) using customer manager keys within a search service.
    :vartype encryption_with_cmk: ~azure.mgmt.search.models.EncryptionWithCmk
    :ivar disable_local_auth: When set to true, calls to the search service will not be permitted
     to utilize API keys for authentication. This cannot be set to true if 'dataPlaneAuthOptions'
     are defined.
    :vartype disable_local_auth: bool
    :ivar auth_options: Defines the options for how the data plane API of a search service
     authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
    :vartype auth_options: ~azure.mgmt.search.models.DataPlaneAuthOptions
    :ivar semantic_search: Sets options that control the availability of semantic search. This
     configuration is only possible for certain Azure AI Search SKUs in certain locations. Known
     values are: "disabled", "free", and "standard".
    :vartype semantic_search: str or ~azure.mgmt.search.models.SearchSemanticSearch
    :ivar private_endpoint_connections: The list of private endpoint connections to the Azure AI
     Search service.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.search.models.PrivateEndpointConnection]
    :ivar shared_private_link_resources: The list of shared private link resources managed by the
     Azure AI Search service.
    :vartype shared_private_link_resources:
     list[~azure.mgmt.search.models.SharedPrivateLinkResource]
    :ivar e_tag: A system generated property representing the service's etag that can be for
     optimistic concurrency control during updates.
    :vartype e_tag: str
    :ivar upgrade_available: Indicates if the search service has an upgrade available. Known values
     are: "notAvailable" and "available".
    :vartype upgrade_available: str or ~azure.mgmt.search.models.UpgradeAvailable
    :ivar service_upgraded_at: The date and time the search service was last upgraded. This field
     will be null until the service gets upgraded for the first time.
    :vartype service_upgraded_at: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "replica_count": {"maximum": 12, "minimum": 1},
        "partition_count": {"maximum": 12, "minimum": 1},
        "status": {"readonly": True},
        "status_details": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "shared_private_link_resources": {"readonly": True},
        "e_tag": {"readonly": True},
        "service_upgraded_at": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "replica_count": {"key": "properties.replicaCount", "type": "int"},
        "partition_count": {"key": "properties.partitionCount", "type": "int"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "hosting_mode": {"key": "properties.hostingMode", "type": "str"},
        "compute_type": {"key": "properties.computeType", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "status_details": {"key": "properties.statusDetails", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "network_rule_set": {"key": "properties.networkRuleSet", "type": "NetworkRuleSet"},
        "data_exfiltration_protections": {"key": "properties.dataExfiltrationProtections", "type": "[str]"},
        "encryption_with_cmk": {"key": "properties.encryptionWithCmk", "type": "EncryptionWithCmk"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "auth_options": {"key": "properties.authOptions", "type": "DataPlaneAuthOptions"},
        "semantic_search": {"key": "properties.semanticSearch", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "shared_private_link_resources": {
            "key": "properties.sharedPrivateLinkResources",
            "type": "[SharedPrivateLinkResource]",
        },
        "e_tag": {"key": "properties.eTag", "type": "str"},
        "upgrade_available": {"key": "properties.upgradeAvailable", "type": "str"},
        "service_upgraded_at": {"key": "properties.serviceUpgradedAt", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        replica_count: int = 1,
        partition_count: int = 1,
        endpoint: Optional[str] = None,
        hosting_mode: Union[str, "_models.HostingMode"] = "default",
        compute_type: Optional[Union[str, "_models.ComputeType"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "enabled",
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        data_exfiltration_protections: Optional[List[Union[str, "_models.SearchDataExfiltrationProtection"]]] = None,
        encryption_with_cmk: Optional["_models.EncryptionWithCmk"] = None,
        disable_local_auth: Optional[bool] = None,
        auth_options: Optional["_models.DataPlaneAuthOptions"] = None,
        semantic_search: Optional[Union[str, "_models.SearchSemanticSearch"]] = None,
        upgrade_available: Optional[Union[str, "_models.UpgradeAvailable"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The SKU of the search service, which determines price tier and capacity limits.
         This property is required when creating a new search service.
        :paramtype sku: ~azure.mgmt.search.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.search.models.Identity
        :keyword replica_count: The number of replicas in the search service. If specified, it must be
         a value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic
         SKU.
        :paramtype replica_count: int
        :keyword partition_count: The number of partitions in the search service; if specified, it can
         be 1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For
         'standard3' services with hostingMode set to 'highDensity', the allowed values are between 1
         and 3.
        :paramtype partition_count: int
        :keyword endpoint: The endpoint of the Azure AI Search service.
        :paramtype endpoint: str
        :keyword hosting_mode: Applicable only for the standard3 SKU. You can set this property to
         enable up to 3 high density partitions that allow up to 1000 indexes, which is much higher than
         the maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either
         'default' or 'highDensity'. For all other SKUs, this value must be 'default'. Known values are:
         "default" and "highDensity".
        :paramtype hosting_mode: str or ~azure.mgmt.search.models.HostingMode
        :keyword compute_type: Configure this property to support the search service using either the
         Default Compute or Azure Confidential Compute. Known values are: "default" and "confidential".
        :paramtype compute_type: str or ~azure.mgmt.search.models.ComputeType
        :keyword public_network_access: This value can be set to 'enabled' to avoid breaking changes on
         existing customer resources and templates. If set to 'disabled', traffic over public interface
         is not allowed, and private endpoint connections would be the exclusive access method. Known
         values are: "enabled", "disabled", and "securedByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.search.models.PublicNetworkAccess
        :keyword network_rule_set: Network specific rules that determine how the Azure AI Search
         service may be reached.
        :paramtype network_rule_set: ~azure.mgmt.search.models.NetworkRuleSet
        :keyword data_exfiltration_protections: A list of data exfiltration scenarios that are
         explicitly disallowed for the search service. Currently, the only supported value is 'All' to
         disable all possible data export scenarios with more fine grained controls planned for the
         future.
        :paramtype data_exfiltration_protections: list[str or
         ~azure.mgmt.search.models.SearchDataExfiltrationProtection]
        :keyword encryption_with_cmk: Specifies any policy regarding encryption of resources (such as
         indexes) using customer manager keys within a search service.
        :paramtype encryption_with_cmk: ~azure.mgmt.search.models.EncryptionWithCmk
        :keyword disable_local_auth: When set to true, calls to the search service will not be
         permitted to utilize API keys for authentication. This cannot be set to true if
         'dataPlaneAuthOptions' are defined.
        :paramtype disable_local_auth: bool
        :keyword auth_options: Defines the options for how the data plane API of a search service
         authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
        :paramtype auth_options: ~azure.mgmt.search.models.DataPlaneAuthOptions
        :keyword semantic_search: Sets options that control the availability of semantic search. This
         configuration is only possible for certain Azure AI Search SKUs in certain locations. Known
         values are: "disabled", "free", and "standard".
        :paramtype semantic_search: str or ~azure.mgmt.search.models.SearchSemanticSearch
        :keyword upgrade_available: Indicates if the search service has an upgrade available. Known
         values are: "notAvailable" and "available".
        :paramtype upgrade_available: str or ~azure.mgmt.search.models.UpgradeAvailable
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.identity = identity
        self.replica_count = replica_count
        self.partition_count = partition_count
        self.endpoint = endpoint
        self.hosting_mode = hosting_mode
        self.compute_type = compute_type
        self.public_network_access = public_network_access
        self.status: Optional[Union[str, "_models.SearchServiceStatus"]] = None
        self.status_details: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.network_rule_set = network_rule_set
        self.data_exfiltration_protections = data_exfiltration_protections
        self.encryption_with_cmk = encryption_with_cmk
        self.disable_local_auth = disable_local_auth
        self.auth_options = auth_options
        self.semantic_search = semantic_search
        self.private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None
        self.shared_private_link_resources: Optional[List["_models.SharedPrivateLinkResource"]] = None
        self.e_tag: Optional[str] = None
        self.upgrade_available = upgrade_available
        self.service_upgraded_at: Optional[datetime.datetime] = None


class SearchServiceListResult(_serialization.Model):
    """Response containing a list of Azure AI Search services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of search services.
    :vartype value: list[~azure.mgmt.search.models.SearchService]
    :ivar next_link: Request URL that can be used to query next page of search services. Returned
     when the total number of requested search services exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SearchService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SearchService"]] = None
        self.next_link: Optional[str] = None


class SearchServiceUpdate(Resource):
    """The parameters used to update an Azure AI Search service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    :ivar sku: The SKU of the search service, which determines price tier and capacity limits. This
     property is required when creating a new search service.
    :vartype sku: ~azure.mgmt.search.models.Sku
    :ivar location: The geographic location of the resource. This must be one of the supported and
     registered Azure geo regions (for example, West US, East US, Southeast Asia, and so forth).
     This property is required when creating a new resource.
    :vartype location: str
    :ivar tags: Tags to help categorize the resource in the Azure portal.
    :vartype tags: dict[str, str]
    :ivar identity: Details about the search service identity. A null value indicates that the
     search service has no identity assigned.
    :vartype identity: ~azure.mgmt.search.models.Identity
    :ivar replica_count: The number of replicas in the search service. If specified, it must be a
     value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic SKU.
    :vartype replica_count: int
    :ivar partition_count: The number of partitions in the search service; if specified, it can be
     1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For 'standard3'
     services with hostingMode set to 'highDensity', the allowed values are between 1 and 3.
    :vartype partition_count: int
    :ivar endpoint: The endpoint of the Azure AI Search service.
    :vartype endpoint: str
    :ivar hosting_mode: Applicable only for the standard3 SKU. You can set this property to enable
     up to 3 high density partitions that allow up to 1000 indexes, which is much higher than the
     maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either 'default'
     or 'highDensity'. For all other SKUs, this value must be 'default'. Known values are: "default"
     and "highDensity".
    :vartype hosting_mode: str or ~azure.mgmt.search.models.HostingMode
    :ivar compute_type: Configure this property to support the search service using either the
     Default Compute or Azure Confidential Compute. Known values are: "default" and "confidential".
    :vartype compute_type: str or ~azure.mgmt.search.models.ComputeType
    :ivar public_network_access: This value can be set to 'enabled' to avoid breaking changes on
     existing customer resources and templates. If set to 'disabled', traffic over public interface
     is not allowed, and private endpoint connections would be the exclusive access method. Known
     values are: "enabled", "disabled", and "securedByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.search.models.PublicNetworkAccess
    :ivar status: The status of the search service. Possible values include: 'running': The search
     service is running and no provisioning operations are underway. 'provisioning': The search
     service is being provisioned or scaled up or down. 'deleting': The search service is being
     deleted. 'degraded': The search service is degraded. This can occur when the underlying search
     units are not healthy. The search service is most likely operational, but performance might be
     slow and some requests might be dropped. 'disabled': The search service is disabled. In this
     state, the service will reject all API requests. 'error': The search service is in an error
     state. 'stopped': The search service is in a subscription that's disabled. If your service is
     in the degraded, disabled, or error states, it means the Azure AI Search team is actively
     investigating the underlying issue. Dedicated services in these states are still chargeable
     based on the number of search units provisioned. Known values are: "running", "provisioning",
     "deleting", "degraded", "disabled", "error", and "stopped".
    :vartype status: str or ~azure.mgmt.search.models.SearchServiceStatus
    :ivar status_details: The details of the search service status.
    :vartype status_details: str
    :ivar provisioning_state: The state of the last provisioning operation performed on the search
     service. Provisioning is an intermediate state that occurs while service capacity is being
     established. After capacity is set up, provisioningState changes to either 'Succeeded' or
     'Failed'. Client applications can poll provisioning status (the recommended polling interval is
     from 30 seconds to one minute) by using the Get Search Service operation to see when an
     operation is completed. If you are using the free service, this value tends to come back as
     'Succeeded' directly in the call to Create search service. This is because the free service
     uses capacity that is already set up. Known values are: "succeeded", "provisioning", and
     "failed".
    :vartype provisioning_state: str or ~azure.mgmt.search.models.ProvisioningState
    :ivar network_rule_set: Network specific rules that determine how the Azure AI Search service
     may be reached.
    :vartype network_rule_set: ~azure.mgmt.search.models.NetworkRuleSet
    :ivar data_exfiltration_protections: A list of data exfiltration scenarios that are explicitly
     disallowed for the search service. Currently, the only supported value is 'All' to disable all
     possible data export scenarios with more fine grained controls planned for the future.
    :vartype data_exfiltration_protections: list[str or
     ~azure.mgmt.search.models.SearchDataExfiltrationProtection]
    :ivar encryption_with_cmk: Specifies any policy regarding encryption of resources (such as
     indexes) using customer manager keys within a search service.
    :vartype encryption_with_cmk: ~azure.mgmt.search.models.EncryptionWithCmk
    :ivar disable_local_auth: When set to true, calls to the search service will not be permitted
     to utilize API keys for authentication. This cannot be set to true if 'dataPlaneAuthOptions'
     are defined.
    :vartype disable_local_auth: bool
    :ivar auth_options: Defines the options for how the data plane API of a search service
     authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
    :vartype auth_options: ~azure.mgmt.search.models.DataPlaneAuthOptions
    :ivar semantic_search: Sets options that control the availability of semantic search. This
     configuration is only possible for certain Azure AI Search SKUs in certain locations. Known
     values are: "disabled", "free", and "standard".
    :vartype semantic_search: str or ~azure.mgmt.search.models.SearchSemanticSearch
    :ivar private_endpoint_connections: The list of private endpoint connections to the Azure AI
     Search service.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.search.models.PrivateEndpointConnection]
    :ivar shared_private_link_resources: The list of shared private link resources managed by the
     Azure AI Search service.
    :vartype shared_private_link_resources:
     list[~azure.mgmt.search.models.SharedPrivateLinkResource]
    :ivar e_tag: A system generated property representing the service's etag that can be for
     optimistic concurrency control during updates.
    :vartype e_tag: str
    :ivar upgrade_available: Indicates if the search service has an upgrade available. Known values
     are: "notAvailable" and "available".
    :vartype upgrade_available: str or ~azure.mgmt.search.models.UpgradeAvailable
    :ivar service_upgraded_at: The date and time the search service was last upgraded. This field
     will be null until the service gets upgraded for the first time.
    :vartype service_upgraded_at: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "replica_count": {"maximum": 12, "minimum": 1},
        "partition_count": {"maximum": 12, "minimum": 1},
        "status": {"readonly": True},
        "status_details": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "shared_private_link_resources": {"readonly": True},
        "e_tag": {"readonly": True},
        "service_upgraded_at": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "replica_count": {"key": "properties.replicaCount", "type": "int"},
        "partition_count": {"key": "properties.partitionCount", "type": "int"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "hosting_mode": {"key": "properties.hostingMode", "type": "str"},
        "compute_type": {"key": "properties.computeType", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "status_details": {"key": "properties.statusDetails", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "network_rule_set": {"key": "properties.networkRuleSet", "type": "NetworkRuleSet"},
        "data_exfiltration_protections": {"key": "properties.dataExfiltrationProtections", "type": "[str]"},
        "encryption_with_cmk": {"key": "properties.encryptionWithCmk", "type": "EncryptionWithCmk"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "auth_options": {"key": "properties.authOptions", "type": "DataPlaneAuthOptions"},
        "semantic_search": {"key": "properties.semanticSearch", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "shared_private_link_resources": {
            "key": "properties.sharedPrivateLinkResources",
            "type": "[SharedPrivateLinkResource]",
        },
        "e_tag": {"key": "properties.eTag", "type": "str"},
        "upgrade_available": {"key": "properties.upgradeAvailable", "type": "str"},
        "service_upgraded_at": {"key": "properties.serviceUpgradedAt", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        replica_count: int = 1,
        partition_count: int = 1,
        endpoint: Optional[str] = None,
        hosting_mode: Union[str, "_models.HostingMode"] = "default",
        compute_type: Optional[Union[str, "_models.ComputeType"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "enabled",
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        data_exfiltration_protections: Optional[List[Union[str, "_models.SearchDataExfiltrationProtection"]]] = None,
        encryption_with_cmk: Optional["_models.EncryptionWithCmk"] = None,
        disable_local_auth: Optional[bool] = None,
        auth_options: Optional["_models.DataPlaneAuthOptions"] = None,
        semantic_search: Optional[Union[str, "_models.SearchSemanticSearch"]] = None,
        upgrade_available: Optional[Union[str, "_models.UpgradeAvailable"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The SKU of the search service, which determines price tier and capacity limits.
         This property is required when creating a new search service.
        :paramtype sku: ~azure.mgmt.search.models.Sku
        :keyword location: The geographic location of the resource. This must be one of the supported
         and registered Azure geo regions (for example, West US, East US, Southeast Asia, and so forth).
         This property is required when creating a new resource.
        :paramtype location: str
        :keyword tags: Tags to help categorize the resource in the Azure portal.
        :paramtype tags: dict[str, str]
        :keyword identity: Details about the search service identity. A null value indicates that the
         search service has no identity assigned.
        :paramtype identity: ~azure.mgmt.search.models.Identity
        :keyword replica_count: The number of replicas in the search service. If specified, it must be
         a value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic
         SKU.
        :paramtype replica_count: int
        :keyword partition_count: The number of partitions in the search service; if specified, it can
         be 1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For
         'standard3' services with hostingMode set to 'highDensity', the allowed values are between 1
         and 3.
        :paramtype partition_count: int
        :keyword endpoint: The endpoint of the Azure AI Search service.
        :paramtype endpoint: str
        :keyword hosting_mode: Applicable only for the standard3 SKU. You can set this property to
         enable up to 3 high density partitions that allow up to 1000 indexes, which is much higher than
         the maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either
         'default' or 'highDensity'. For all other SKUs, this value must be 'default'. Known values are:
         "default" and "highDensity".
        :paramtype hosting_mode: str or ~azure.mgmt.search.models.HostingMode
        :keyword compute_type: Configure this property to support the search service using either the
         Default Compute or Azure Confidential Compute. Known values are: "default" and "confidential".
        :paramtype compute_type: str or ~azure.mgmt.search.models.ComputeType
        :keyword public_network_access: This value can be set to 'enabled' to avoid breaking changes on
         existing customer resources and templates. If set to 'disabled', traffic over public interface
         is not allowed, and private endpoint connections would be the exclusive access method. Known
         values are: "enabled", "disabled", and "securedByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.search.models.PublicNetworkAccess
        :keyword network_rule_set: Network specific rules that determine how the Azure AI Search
         service may be reached.
        :paramtype network_rule_set: ~azure.mgmt.search.models.NetworkRuleSet
        :keyword data_exfiltration_protections: A list of data exfiltration scenarios that are
         explicitly disallowed for the search service. Currently, the only supported value is 'All' to
         disable all possible data export scenarios with more fine grained controls planned for the
         future.
        :paramtype data_exfiltration_protections: list[str or
         ~azure.mgmt.search.models.SearchDataExfiltrationProtection]
        :keyword encryption_with_cmk: Specifies any policy regarding encryption of resources (such as
         indexes) using customer manager keys within a search service.
        :paramtype encryption_with_cmk: ~azure.mgmt.search.models.EncryptionWithCmk
        :keyword disable_local_auth: When set to true, calls to the search service will not be
         permitted to utilize API keys for authentication. This cannot be set to true if
         'dataPlaneAuthOptions' are defined.
        :paramtype disable_local_auth: bool
        :keyword auth_options: Defines the options for how the data plane API of a search service
         authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
        :paramtype auth_options: ~azure.mgmt.search.models.DataPlaneAuthOptions
        :keyword semantic_search: Sets options that control the availability of semantic search. This
         configuration is only possible for certain Azure AI Search SKUs in certain locations. Known
         values are: "disabled", "free", and "standard".
        :paramtype semantic_search: str or ~azure.mgmt.search.models.SearchSemanticSearch
        :keyword upgrade_available: Indicates if the search service has an upgrade available. Known
         values are: "notAvailable" and "available".
        :paramtype upgrade_available: str or ~azure.mgmt.search.models.UpgradeAvailable
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.tags = tags
        self.identity = identity
        self.replica_count = replica_count
        self.partition_count = partition_count
        self.endpoint = endpoint
        self.hosting_mode = hosting_mode
        self.compute_type = compute_type
        self.public_network_access = public_network_access
        self.status: Optional[Union[str, "_models.SearchServiceStatus"]] = None
        self.status_details: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.network_rule_set = network_rule_set
        self.data_exfiltration_protections = data_exfiltration_protections
        self.encryption_with_cmk = encryption_with_cmk
        self.disable_local_auth = disable_local_auth
        self.auth_options = auth_options
        self.semantic_search = semantic_search
        self.private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None
        self.shared_private_link_resources: Optional[List["_models.SharedPrivateLinkResource"]] = None
        self.e_tag: Optional[str] = None
        self.upgrade_available = upgrade_available
        self.service_upgraded_at: Optional[datetime.datetime] = None


class ShareablePrivateLinkResourceProperties(_serialization.Model):
    """Describes the properties of a resource type that has been onboarded to private link service,
    supported by Azure AI Search.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The resource provider type for the resource that has been onboarded to private link
     service, supported by Azure AI Search.
    :vartype type: str
    :ivar group_id: The resource provider group id for the resource that has been onboarded to
     private link service, supported by Azure AI Search.
    :vartype group_id: str
    :ivar description: The description of the resource type that has been onboarded to private link
     service, supported by Azure AI Search.
    :vartype description: str
    """

    _validation = {
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.group_id: Optional[str] = None
        self.description: Optional[str] = None


class ShareablePrivateLinkResourceType(_serialization.Model):
    """Describes an resource type that has been onboarded to private link service, supported by Azure
    AI Search.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource type that has been onboarded to private link service,
     supported by Azure AI Search.
    :vartype name: str
    :ivar properties: Describes the properties of a resource type that has been onboarded to
     private link service, supported by Azure AI Search.
    :vartype properties: ~azure.mgmt.search.models.ShareablePrivateLinkResourceProperties
    """

    _validation = {
        "name": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "ShareablePrivateLinkResourceProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.properties: Optional["_models.ShareablePrivateLinkResourceProperties"] = None


class SharedPrivateLinkResource(Resource):
    """Describes a shared private link resource managed by the Azure AI Search service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.search.models.SystemData
    :ivar properties: Describes the properties of a shared private link resource managed by the
     Azure AI Search service.
    :vartype properties: ~azure.mgmt.search.models.SharedPrivateLinkResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SharedPrivateLinkResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.SharedPrivateLinkResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Describes the properties of a shared private link resource managed by the
         Azure AI Search service.
        :paramtype properties: ~azure.mgmt.search.models.SharedPrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SharedPrivateLinkResourceListResult(_serialization.Model):
    """Response containing a list of shared private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of shared private link resources.
    :vartype value: list[~azure.mgmt.search.models.SharedPrivateLinkResource]
    :ivar next_link: The URL to get the next set of shared private link resources, if there are
     any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedPrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The URL to get the next set of shared private link resources, if there are
         any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SharedPrivateLinkResource"]] = None
        self.next_link = next_link


class SharedPrivateLinkResourceProperties(_serialization.Model):
    """Describes the properties of an existing shared private link resource managed by the Azure AI
    Search service.

    :ivar private_link_resource_id: The resource ID of the resource the shared private link
     resource is for.
    :vartype private_link_resource_id: str
    :ivar group_id: The group ID from the provider of resource the shared private link resource is
     for.
    :vartype group_id: str
    :ivar request_message: The message for requesting approval of the shared private link resource.
    :vartype request_message: str
    :ivar resource_region: Optional. Can be used to specify the Azure Resource Manager location of
     the resource for which a shared private link is being created. This is only required for those
     resources whose DNS configuration are regional (such as Azure Kubernetes Service).
    :vartype resource_region: str
    :ivar status: Status of the shared private link resource. Valid values are Pending, Approved,
     Rejected or Disconnected. Known values are: "Pending", "Approved", "Rejected", and
     "Disconnected".
    :vartype status: str or ~azure.mgmt.search.models.SharedPrivateLinkResourceStatus
    :ivar provisioning_state: The provisioning state of the shared private link resource. Valid
     values are Updating, Deleting, Failed, Succeeded or Incomplete. Known values are: "Updating",
     "Deleting", "Failed", "Succeeded", and "Incomplete".
    :vartype provisioning_state: str or
     ~azure.mgmt.search.models.SharedPrivateLinkResourceProvisioningState
    """

    _attribute_map = {
        "private_link_resource_id": {"key": "privateLinkResourceId", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "request_message": {"key": "requestMessage", "type": "str"},
        "resource_region": {"key": "resourceRegion", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_link_resource_id: Optional[str] = None,
        group_id: Optional[str] = None,
        request_message: Optional[str] = None,
        resource_region: Optional[str] = None,
        status: Optional[Union[str, "_models.SharedPrivateLinkResourceStatus"]] = None,
        provisioning_state: Optional[Union[str, "_models.SharedPrivateLinkResourceProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_link_resource_id: The resource ID of the resource the shared private link
         resource is for.
        :paramtype private_link_resource_id: str
        :keyword group_id: The group ID from the provider of resource the shared private link resource
         is for.
        :paramtype group_id: str
        :keyword request_message: The message for requesting approval of the shared private link
         resource.
        :paramtype request_message: str
        :keyword resource_region: Optional. Can be used to specify the Azure Resource Manager location
         of the resource for which a shared private link is being created. This is only required for
         those resources whose DNS configuration are regional (such as Azure Kubernetes Service).
        :paramtype resource_region: str
        :keyword status: Status of the shared private link resource. Valid values are Pending,
         Approved, Rejected or Disconnected. Known values are: "Pending", "Approved", "Rejected", and
         "Disconnected".
        :paramtype status: str or ~azure.mgmt.search.models.SharedPrivateLinkResourceStatus
        :keyword provisioning_state: The provisioning state of the shared private link resource. Valid
         values are Updating, Deleting, Failed, Succeeded or Incomplete. Known values are: "Updating",
         "Deleting", "Failed", "Succeeded", and "Incomplete".
        :paramtype provisioning_state: str or
         ~azure.mgmt.search.models.SharedPrivateLinkResourceProvisioningState
        """
        super().__init__(**kwargs)
        self.private_link_resource_id = private_link_resource_id
        self.group_id = group_id
        self.request_message = request_message
        self.resource_region = resource_region
        self.status = status
        self.provisioning_state = provisioning_state


class Sku(_serialization.Model):
    """Defines the SKU of a search service, which determines billing rate and capacity limits.

    :ivar name: The SKU of the search service. Valid values include: 'free': Shared service.
     'basic': Dedicated service with up to 3 replicas. 'standard': Dedicated service with up to 12
     partitions and 12 replicas. 'standard2': Similar to standard, but with more capacity per search
     unit. 'standard3': The largest Standard offering with up to 12 partitions and 12 replicas (or
     up to 3 partitions with more indexes if you also set the hostingMode property to
     'highDensity'). 'storage_optimized_l1': Supports 1TB per partition, up to 12 partitions.
     'storage_optimized_l2': Supports 2TB per partition, up to 12 partitions.'. Known values are:
     "free", "basic", "standard", "standard2", "standard3", "storage_optimized_l1", and
     "storage_optimized_l2".
    :vartype name: str or ~azure.mgmt.search.models.SkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.SkuName"]] = None, **kwargs: Any) -> None:
        """
        :keyword name: The SKU of the search service. Valid values include: 'free': Shared service.
         'basic': Dedicated service with up to 3 replicas. 'standard': Dedicated service with up to 12
         partitions and 12 replicas. 'standard2': Similar to standard, but with more capacity per search
         unit. 'standard3': The largest Standard offering with up to 12 partitions and 12 replicas (or
         up to 3 partitions with more indexes if you also set the hostingMode property to
         'highDensity'). 'storage_optimized_l1': Supports 1TB per partition, up to 12 partitions.
         'storage_optimized_l2': Supports 2TB per partition, up to 12 partitions.'. Known values are:
         "free", "basic", "standard", "standard2", "standard3", "storage_optimized_l1", and
         "storage_optimized_l2".
        :paramtype name: str or ~azure.mgmt.search.models.SkuName
        """
        super().__init__(**kwargs)
        self.name = name


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.search.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.search.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.search.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.search.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None
