# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._operations._operations import (
    build_question_answering_get_answers_from_text_request,
    build_question_answering_get_answers_request,
)
from ..._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._utils.utils import ClientMixinABC
from .._configuration import QuestionAnsweringClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class _QuestionAnsweringClientOperationsMixin(
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], QuestionAnsweringClientConfiguration]
):

    @overload
    async def get_answers(
        self,
        knowledge_base_query_options: _models.AnswersOptions,
        *,
        project_name: str,
        deployment_name: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AnswersResult:
        """Answers the specified question using your knowledge base.

        :param knowledge_base_query_options: Post body of the request. Required.
        :type knowledge_base_query_options: ~azure.ai.language.questionanswering.models.AnswersOptions
        :keyword project_name: The name of the project to use. Required.
        :paramtype project_name: str
        :keyword deployment_name: The name of the specific deployment of the project to use. Required.
        :paramtype deployment_name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersResult. The AnswersResult is compatible with MutableMapping
        :rtype: ~azure.ai.language.questionanswering.models.AnswersResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_answers(
        self,
        knowledge_base_query_options: JSON,
        *,
        project_name: str,
        deployment_name: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AnswersResult:
        """Answers the specified question using your knowledge base.

        :param knowledge_base_query_options: Post body of the request. Required.
        :type knowledge_base_query_options: JSON
        :keyword project_name: The name of the project to use. Required.
        :paramtype project_name: str
        :keyword deployment_name: The name of the specific deployment of the project to use. Required.
        :paramtype deployment_name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersResult. The AnswersResult is compatible with MutableMapping
        :rtype: ~azure.ai.language.questionanswering.models.AnswersResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_answers(
        self,
        knowledge_base_query_options: IO[bytes],
        *,
        project_name: str,
        deployment_name: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AnswersResult:
        """Answers the specified question using your knowledge base.

        :param knowledge_base_query_options: Post body of the request. Required.
        :type knowledge_base_query_options: IO[bytes]
        :keyword project_name: The name of the project to use. Required.
        :paramtype project_name: str
        :keyword deployment_name: The name of the specific deployment of the project to use. Required.
        :paramtype deployment_name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersResult. The AnswersResult is compatible with MutableMapping
        :rtype: ~azure.ai.language.questionanswering.models.AnswersResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def get_answers(
        self,
        knowledge_base_query_options: Union[_models.AnswersOptions, JSON, IO[bytes]],
        *,
        project_name: str,
        deployment_name: str,
        **kwargs: Any
    ) -> _models.AnswersResult:
        """Answers the specified question using your knowledge base.

        :param knowledge_base_query_options: Post body of the request. Is one of the following types:
         AnswersOptions, JSON, IO[bytes] Required.
        :type knowledge_base_query_options: ~azure.ai.language.questionanswering.models.AnswersOptions
         or JSON or IO[bytes]
        :keyword project_name: The name of the project to use. Required.
        :paramtype project_name: str
        :keyword deployment_name: The name of the specific deployment of the project to use. Required.
        :paramtype deployment_name: str
        :return: AnswersResult. The AnswersResult is compatible with MutableMapping
        :rtype: ~azure.ai.language.questionanswering.models.AnswersResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AnswersResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(knowledge_base_query_options, (IOBase, bytes)):
            _content = knowledge_base_query_options
        else:
            _content = json.dumps(knowledge_base_query_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_question_answering_get_answers_request(
            project_name=project_name,
            deployment_name=deployment_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AnswersResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def get_answers_from_text(
        self,
        text_query_options: _models.AnswersFromTextOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AnswersFromTextResult:
        """Answers the specified question using the provided text in the body.

        :param text_query_options: Post body of the request. Required.
        :type text_query_options: ~azure.ai.language.questionanswering.models.AnswersFromTextOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersFromTextResult. The AnswersFromTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.language.questionanswering.models.AnswersFromTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_answers_from_text(
        self, text_query_options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnswersFromTextResult:
        """Answers the specified question using the provided text in the body.

        :param text_query_options: Post body of the request. Required.
        :type text_query_options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersFromTextResult. The AnswersFromTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.language.questionanswering.models.AnswersFromTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_answers_from_text(
        self, text_query_options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnswersFromTextResult:
        """Answers the specified question using the provided text in the body.

        :param text_query_options: Post body of the request. Required.
        :type text_query_options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersFromTextResult. The AnswersFromTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.language.questionanswering.models.AnswersFromTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def get_answers_from_text(
        self, text_query_options: Union[_models.AnswersFromTextOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AnswersFromTextResult:
        """Answers the specified question using the provided text in the body.

        :param text_query_options: Post body of the request. Is one of the following types:
         AnswersFromTextOptions, JSON, IO[bytes] Required.
        :type text_query_options: ~azure.ai.language.questionanswering.models.AnswersFromTextOptions or
         JSON or IO[bytes]
        :return: AnswersFromTextResult. The AnswersFromTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.language.questionanswering.models.AnswersFromTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AnswersFromTextResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(text_query_options, (IOBase, bytes)):
            _content = text_query_options
        else:
            _content = json.dumps(text_query_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_question_answering_get_answers_from_text_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AnswersFromTextResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
