% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api-cancel.R
\name{cancel}
\alias{cancel}
\title{Cancel a future}
\usage{
cancel(x, interrupt = TRUE, ...)
}
\arguments{
\item{x}{A Future.}

\item{interrupt}{If TRUE, running futures are interrupted, if the
future backend supports it.}

\item{\ldots}{All arguments used by the S3 methods.}
}
\value{
\code{cancel()} returns (invisibly) the canceled \link{Future}s after
flagging them as "canceled" and possibly interrupting them as well.

Canceling a lazy or a finished future has no effect.
}
\description{
Cancels futures, with the option to interrupt running ones.
}
\examples{
\dontshow{if ((interactive() || .Platform[["OS.type"]] != "windows")) withAutoprint(\{ # examplesIf}
## Set up two parallel workers
plan(multisession, workers = 2)

## Launch two long running future
fs <- lapply(c(1, 2), function(duration) {
  future({
    Sys.sleep(duration)
    42
  })
})

## Wait until at least one of the futures is resolved
while (!any(resolved(fs))) Sys.sleep(0.1)

## Cancel the future that is not yet resolved
r <- resolved(fs)
cancel(fs[!r])

## Get the value of the resolved future
f <- fs[r]
v <- value(f)
message("Result: ", v)

## The value of the canceled future is an error
try(v <- value(fs[!r]))

## Shut down parallel workers
plan(sequential)
\dontshow{\}) # examplesIf}
}
\seealso{
A canceled future can be \code{\link[=reset]{reset()}} to a lazy, vanilla future
such that it can be relaunched, possible on another future backend.
}
